using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System.ComponentModel;
using System.Drawing;


namespace StrataFlix.UI
{
    namespace Windows
    {
        namespace Forms
        {


            public class ActionLinkMenuItem : ThemedLinkMenuItem, IComponent
            {


                #region " Constructors "

                /// <summary>
                /// Initializes a new instance of the ActionLinkMenuItem class.
                /// </summary>
                /// <remarks></remarks>
                public ActionLinkMenuItem()
                {
                }

                /// <summary>
                /// Initializes a new instance of the ActionLinkMenuItem class.
                /// </summary>
                /// <param name="Title"></param>
                /// <param name="Key"></param>
                /// <param name="Icon"></param>
                /// <param name="Handler"></param>
                /// <param name="Visible"></param>
                /// <remarks></remarks>
                public ActionLinkMenuItem(string Title, string Key, Image Icon, ClickHandler Handler, bool Visible)
                {
                    this.Title = Title;
                    this.Key = Key;
                    this.ItemImage = Icon;
                    this._Handler = Handler;
                    this.Visible = Visible;
                }

                #endregion

                #region " Private Fields "

                private ClickHandler _Handler;
                private ISite _Site;

                #endregion

                #region " Events "

                /// <summary>
                /// Occurs when this action is clicked.
                /// </summary>
                /// <remarks></remarks>
                public event ClickHandler Click
                {
                    add
                    {
                        this._Handler = (ClickHandler)(@Delegate.Combine(this._Handler, value));
                    }
                    remove
                    {
                        this._Handler = (ClickHandler)(@Delegate.Remove(this._Handler, value));
                    }
                }

                /// <summary>
                /// Occurs when this object is disposed.
                /// </summary>
                /// <remarks></remarks>
                private EventHandler DisposedEvent;
                public event EventHandler Disposed
                {
                    add
                    {
                        DisposedEvent = (EventHandler)System.Delegate.Combine(DisposedEvent, value);
                    }
                    remove
                    {
                        DisposedEvent = (EventHandler)System.Delegate.Remove(DisposedEvent, value);
                    }
                }


                #endregion

                #region " Public Properties "

                /// <summary>
                /// Gets or sets the site for this component.
                /// </summary>
                /// <value></value>
                /// <returns></returns>
                /// <remarks></remarks>
                [Browsable(false)]
                public System.ComponentModel.ISite Site
                {
                    get
                    {
                        return this._Site;
                    }
                    set
                    {
                        this._Site = value;
                    }
                }

                #endregion

                #region " Public Methods "

                public void Dispose()
                {

                }

                /// <summary>
                /// Calls the internal click handler for the link menu.
                /// </summary>
                /// <remarks></remarks>
                public void OnClick()
                {
                    //-- Call the internal handler
                    if (this._Handler != null)
                        this._Handler();
                }

                #endregion

                #region " Nested Types "

                /// <summary>
                /// Describes a method that will be called when the link item is clicked.
                /// </summary>
                /// <remarks></remarks>
                public delegate void ClickHandler();

                #endregion

            }

        }
    }
}
